from machine import Pin
import neopixel
import time
import random

pin = Pin(25, Pin.OUT)
np = neopixel.NeoPixel(pin, n=4, bpp=3, timing=1)
def setup():           #重置所有RGB灯，熄灭
    for i in range(0,4):
        np[i] = (0,0,0)
    np.write()
if __name__ == '__main__':
    while True:
        rgb_red = int(random.randint(0,255))
        rgb_green = int(random.randint(0,255))
        rgb_blue = int(random.randint(0,255))
        for n in range(0,255):
            br_value = n / 255
            for i in range(0,4):
                np[i] = (int(rgb_red * br_value),int(rgb_green * br_value),int(rgb_blue * br_value))
            np.write()
            time.sleep(0.01)
        for n in range(255,0,-1):
            br_value = n / 255
            for i in range(0,4):
                np[i] = (int(rgb_red * br_value),int(rgb_green * br_value),int(rgb_blue * br_value))
            np.write()
            time.sleep(0.01)
        #setup()